%% A1_export_kaenzig_baseline.m
% Export baseline data and results from Känzig replication run (after s03_figures3_5.m)

fprintf('\n=== A1: Export Känzig baseline ===\n');

outDir = fullfile(fileparts(fileparts(mfilename('fullpath'))),'Data','kaenzig_exports');
if ~exist(outDir,'dir'), mkdir(outDir); end
w = @(X,fn) writematrix(X, fullfile(outDir,fn));

%% Baseline dataset
baseline_headers = {'RealOilPrice','WorldOilProduction','WorldOilInventories', ...
                    'WorldIndustrialProduction','USIndustrialProduction','USCPI'};
Tb = addvars(array2table(data,'VariableNames',baseline_headers), string(sampleDates(:)), ...
             'Before',1,'NewVariableNames',{'time'});
writetable(Tb, fullfile(outDir,'kaenzig_baseline_data.csv'));

%% IRFs
H = size(IRFs_proxy,1)-1;
w((0:H)','kaenzig_baseline_irf_horizon.csv');
w(IRFs_proxy,'kaenzig_baseline_irf_point.csv');
w(IRFslower_proxy,'kaenzig_baseline_irf_lo90.csv');
w(IRFsupper_proxy,'kaenzig_baseline_irf_hi90.csv');
w(IRFslower2_proxy,'kaenzig_baseline_irf_lo68.csv');
w(IRFsupper2_proxy,'kaenzig_baseline_irf_hi68.csv');

%% Variable names
writecell(varNames_paper(:), fullfile(outDir,'kaenzig_baseline_varnames.csv'));

%% Historical decomposition (first variable)
t  = sampleDatesNum(smplStartProxyVARInd:smplEndProxyVARInd);
a  = varEst.Y(:,1); a = a - mean(a);
hd = [HDshock(:,1) HDshocklower(:,1) HDshockupper(:,1) HDshocklower2(:,1) HDshockupper2(:,1)];
hd = hd - mean(HDshock(:,1));
w([t(:) a(:) hd], 'kaenzig_baseline_hd.csv');

%% b1 / U / proxy
w(b1(:),'kaenzig_baseline_b1.csv');
w(U,'kaenzig_baseline_U.csv');
w(proxy,'kaenzig_baseline_proxy.csv');

fprintf('=== Done: baseline export ===\n\n');
