%% A3_export_structural_shocks_baseline_and_extensions.m
% Computes structural shock series from exported b1 and U (baseline + extensions)
% and writes them to CSV in Data/kaenzig_exports.

fprintf('\n=== Computing structural shock series ===\n');

%% Setup
addpath(fullfile(pwd,'A3_lib'));

d = fullfile(fileparts(fileparts(mfilename('fullpath'))),'Data','kaenzig_exports');
r = @(f) readmatrix(fullfile(d,f));

%% Baseline
e = shock_from_b1_U(r('kaenzig_baseline_b1.csv'), r('kaenzig_baseline_U.csv'));
t = r('kaenzig_baseline_hd.csv'); 
t = t(:,1);

writetable(table(t(:),e(:),'VariableNames',{'timeNum','shock'}), ...
    fullfile(d,'kaenzig_baseline_structural_shock.csv'));

fprintf('-> Baseline done\n');

%% Extensions
tags = {'UnemploymentRate','PCE','OilPriceExpectations','InflationExpectationsMichigan', ...
        'VXO','GeopoliticalRisk','FedFundsRate','ExcessBondPremium', ...
        'SP500','NEERBroad','NEERMajor','TermsOfTrade'};

fprintf('-> Extensions...\n');

for j = 1:numel(tags)
    tag = tags{j};
    fprintf('   [%2d/%2d] %s...\n', j, numel(tags), tag);

    e = shock_from_b1_U( ...
        r(['kaenzig_extensions_' tag '_b1.csv']), ...
        r(['kaenzig_extensions_' tag '_U.csv']) );

    t = r(['kaenzig_extensions_' tag '_timeNum.csv']);
    t = t(end-numel(e)+1:end);

    writetable(table(t(:),e(:),'VariableNames',{'timeNum','shock'}), ...
        fullfile(d,['kaenzig_extensions_' tag '_structural_shock.csv']));
end

fprintf('=== Structural shock export finished successfully ===\n\n');
