function [JB, p] = jb_test_simple(x)
% Univariate Jarque-Bera test
x = x(:);
x = x(~isnan(x));
n = numel(x);

m  = mean(x);
v  = mean((x - m).^2);
s  = mean((x - m).^3) / (v^(3/2));
k  = mean((x - m).^4) / (v^2);

JB = (n/6) * (s^2 + 0.25*(k - 3)^2);
p  = 1 - chi2cdf(JB, 2);
end