function plot_hd_compare(HD_T, HD_K, outpdf)

tK = HD_K.t(:);
tT = HD_T.t(:);
yT = HD_T.y(:);

% demean this paper contribution (old figure did that)
yT = yT - mean(yT,'omitnan');

has90 = isfield(HD_K,'lo90') && isfield(HD_K,'hi90');
has68 = isfield(HD_K,'lo68') && isfield(HD_K,'hi68');

fh = figure('Visible','off','Position',[100 100 1250 440], ...
            'DefaultAxesFontSize',13,'Color','w'); hold on;

% bands (Kaenzig)
if has90
    fill([tK; flipud(tK)], [HD_K.lo90(:); flipud(HD_K.hi90(:))], ...
         [0.1 0.4470 0.7410], 'FaceAlpha',0.20, 'EdgeColor','none');
end
if has68
    fill([tK; flipud(tK)], [HD_K.lo68(:); flipud(HD_K.hi68(:))], ...
         [0.1 0.4470 0.7410], 'FaceAlpha',0.40, 'EdgeColor','none');
end

% lines
f1 = plot(tK, HD_K.actual(:), 'Color',[0.8500 0.3250 0.0980], 'LineWidth',2, 'LineStyle',':');
f2 = plot(tK, HD_K.point(:),  'k', 'LineWidth',2);
f3 = plot(tT, yT,             'Color',[0.90 0.00 0.50], 'LineWidth',2);

grid on; box on;
xlim([min(tK) max(tK)]);
xticks(datenum(1975:5:year(datetime('today')),1,1));
datetick('x','yyyy','keeplimits','keepticks');
ylim([-150 150]);
ylabel('\%');

L = legend([f1 f2 f3], ...
   {'Real oil price', ...
    'Contribution of K\"anzig''s shock ($w^{K}_{t}$)', ...
    'Contribution of Non-Gaussian shock ($w^{nG}_{t}$)'}, ...
   'Location','southwest','Interpreter','latex','Box','on');
L.FontSize = 16;
L.FontName = get(gca,'FontName');
L.FontWeight = 'normal';

set(findall(fh,'Type','axes'),'FontSize',17);
set(fh,'Renderer','painters');
ax = gca;
ti = ax.TightInset;
ax.LooseInset = [ti(1)+0.06 ti(2)+0.06 ti(3)+0.06 ti(4)+0.06];
exportgraphics(fh,outpdf,'ContentType','vector','BackgroundColor','white');
close(fh);

end