function plot_irf_compare(IRF_T, IRF_K, ~, outpdf)

% --- FORCE hardcoded subheaders (ignore any input varnames) ---
varnames = {'Real oil price','World oil production','World oil inventories', ...
    'World industrial production','U.S. industrial production','U.S. CPI'};

FIG_WIDTH  = 1400;
FIG_HEIGHT = 1900;
dpi = 150;

colTitleLeft  = 'Non-Gaussian identification';
colTitleRight = "Känzig's identification by proxy";

H = min(numel(IRF_T.h), numel(IRF_K.h));
t = IRF_T.h(1:H);

XT   = IRF_T.pt(1:H,:);   XK   = IRF_K.pt(1:H,:);
Tlo90= IRF_T.lo90(1:H,:); Thi90= IRF_T.hi90(1:H,:);
Tlo68= IRF_T.lo68(1:H,:); Thi68= IRF_T.hi68(1:H,:);
Klo90= IRF_K.lo90(1:H,:); Khi90= IRF_K.hi90(1:H,:);
Klo68= IRF_K.lo68(1:H,:); Khi68= IRF_K.hi68(1:H,:);

K = min([size(XT,2), size(XK,2), 6]);

% --- normalize THIS PAPER to impact=10 ---
if isfinite(XT(1,1)) && XT(1,1)~=0 && abs(XT(1,1)-10)>1e-6
    sc = 10/XT(1,1);
    XT=XT*sc; Tlo90=Tlo90*sc; Thi90=Thi90*sc; Tlo68=Tlo68*sc; Thi68=Thi68*sc;
end

fh = figure('Units','pixels','Position',[100 100 FIG_WIDTH FIG_HEIGHT], ...
    'PaperPositionMode','auto','DefaultAxesFontSize',16, ...
    'DefaultAxesFontName','Arial','DefaultTextFontName','Arial', ...
    'DefaultAxesTitleFontWeight','normal', ...
    'Visible','off','Color','w');

tl = tiledlayout(fh,6,2,'TileSpacing','loose','Padding','compact');

for j=1:K
    [ymin,ymax] = common_ylim(XT(:,j),Tlo90(:,j),Thi90(:,j),XK(:,j),Klo90(:,j),Khi90(:,j));
    xlab = ' '; if j==K, xlab='Months'; end

    if j==1
        ttlL = sprintf('%s\n%s', colTitleLeft,  varnames{j});
        ttlR = sprintf('%s\n%s', colTitleRight, varnames{j});
    else
        ttlL = varnames{j};
        ttlR = varnames{j};
    end

    axL = nexttile(tl,(j-1)*2+1);
    panel(axL,t,XT(:,j),Tlo90(:,j),Thi90(:,j),Tlo68(:,j),Thi68(:,j),true, ttlL, xlab);
    ylim(axL,[ymin ymax]);

    axR = nexttile(tl,(j-1)*2+2);
    panel(axR,t,XK(:,j),Klo90(:,j),Khi90(:,j),Klo68(:,j),Khi68(:,j),false,ttlR, xlab);
    ylim(axR,[ymin ymax]);
end

% --- preserve aspect exactly ---
paperW = FIG_WIDTH/dpi; paperH = FIG_HEIGHT/dpi;
set(fh,'PaperUnits','inches','PaperPosition',[0 0 paperW paperH],'PaperSize',[paperW paperH]);
set(fh,'Renderer','painters');
print(fh,outpdf,'-dpdf',['-r' num2str(dpi)]);
close(fh);

end

% ---------------- helpers ----------------
function panel(ax,t,y,lo90,hi90,lo68,hi68,isMy,ttl,xlab)
axes(ax); hold(ax,'on');

if all(isfinite(lo90)) && all(isfinite(hi90))
    if isMy, c90=[0.70 0.50 0.80]; else, c90=[0.1 0.4470 0.7410]; end
    fill(ax,[t;flipud(t)],[lo90;flipud(hi90)],c90,'FaceAlpha',0.35,'EdgeColor','none');
end
if all(isfinite(lo68)) && all(isfinite(hi68))
    if isMy, c68=[0.45 0.00 0.45]; else, c68=[0.1 0.4470 0.7410]; end
    fill(ax,[t;flipud(t)],[lo68;flipud(hi68)],c68,'FaceAlpha',0.45,'EdgeColor','none');
end

plot(ax,t,zeros(size(t)),'k-');
plot(ax,t,y,'k','LineWidth',1.5);

grid(ax,'on'); box(ax,'on');
ylabel(ax,'%');
xlim(ax,[t(1) t(end)]);
xticks(ax,t(1):10:t(end));
xlabel(ax,xlab);

% --- NO title(): draw header as unclipped text ---
L = splitlines(string(ttl));

y0 = 1.05;   % slightly lower -> stays inside PDF
dy = 0.13;   % generous spacing between lines

for k = 1:numel(L)
    text(ax, 0.5, y0 + (numel(L)-k)*dy, L(k), ...
        'Units','normalized', ...
        'HorizontalAlignment','center', ...
        'VerticalAlignment','bottom', ...
        'Interpreter','none', ...
        'FontSize',14, ...
        'FontWeight','normal', ...
        'Clipping','off');
end

hold(ax,'off');
end

function [ymin,ymax] = common_ylim(y1,lo1,hi1,y2,lo2,hi2)
mn = [y1(:);y2(:);lo1(:);lo2(:)];
mx = [y1(:);y2(:);hi1(:);hi2(:)];
ymin = min(mn(isfinite(mn))); ymax = max(mx(isfinite(mx)));
if ~isfinite(ymin) || ~isfinite(ymax), ymin=0; ymax=0; end
if ymin==ymax
    pad=max(1e-8,0.05*max(abs([ymin ymax])));
    ymin=ymin-pad; ymax=ymax+pad;
end
end