function S = read_hd_series(fn)

M = readmatrix(fn);

S = struct();

% Kaenzig format: time + actual + point + lo90 + hi90 + lo68 + hi68
if size(M,2) >= 7
    S.t     = M(:,1);
    S.actual= M(:,2);
    S.point = M(:,3);
    S.lo90  = M(:,4);
    S.hi90  = M(:,5);
    S.lo68  = M(:,6);
    S.hi68  = M(:,7);
    return
end

% Generic: (time, series) or just series
if size(M,2) >= 2
    S.t = M(:,1);
    S.y = M(:,2);
else
    S.t = (1:size(M,1))';
    S.y = M(:,1);
end

end