%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Replication File: MAIN.m
% Purpose: Replicates results from the main paper (including estimates, figures and tables)
% Paper: "Time-Varying Shock Transmission in Non-Gaussian Structural Vector Autoregressions"
% Author: Helmut Lütkepohl and Till Strohsal
% Date: 12.12.2025
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear; close all; clc; nod=2;

%% 1. Estimate recursive B-Matrix (Kilian 2009) over full sample
estimate_recursive_B_full;

%% 2. Estimate B-Matrix identified through non-normality over full sample
estimate_nonnormal_B_full;

%% 3. Produce Figure 1 from reduced-form residuals
create_figure1;

%% 4. Estimate recursive B-Matrix for each subsample
estimate_recursive_B_subsamples;

%% 5. Estimate B-Matrix identified through non-normality for each subsample
estimate_nonnormal_B_subsamples;

%% 6. Produce main empirical test results for time-varying transmission (Tables 1 and 2)
compute_tests_tables_1_and_2;

%% 7. Produce robustness checks for break date (+- 1,2 months in Tables 1 and 2)
compute_tests_tables_1_and_2_robustness;

%% 8. Produce Figure 2
create_figure2;

%% 9. Perform non-normality and independence tests
non_normality_tests;



