%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Estimate B-matrices and theta vectors for all break variants %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [B_nG_1_minus2, B_nG_2_minus2, theta_hat_1_main_minus2, theta_hat_2_main_minus2, ...
    B_nG_1_minus1, B_nG_2_minus1, theta_hat_1_main_minus1, theta_hat_2_main_minus1, ...
    B_nG_1_plus1,  B_nG_2_plus1,  theta_hat_1_main_plus1,  theta_hat_2_main_plus1,  ...
    B_nG_1_plus2,  B_nG_2_plus2,  theta_hat_1_main_plus2,  theta_hat_2_main_plus2] = ...
    Non_normal_B_for_tables_1_and_2_robustness(Uhat_1_minus2, Uhat_2_minus2, ...
    Uhat_1_minus1, Uhat_2_minus1, ...
    Uhat_1_plus1,  Uhat_2_plus1,  ...
    Uhat_1_plus2,  Uhat_2_plus2, ...
    SIGMA_1_minus2, SIGMA_2_minus2, ...
    SIGMA_1_minus1, SIGMA_2_minus1, ...
    SIGMA_1_plus1,  SIGMA_2_plus1,  ...
    SIGMA_1_plus2,  SIGMA_2_plus2, nod)

v = 4;                % Degrees of freedom for t-distribution
K = 3;                % Number of variables
theta0 = [-0.25*pi; 0.25*pi; 0.4*pi]*1.1;
A = []; b = []; Aeq = []; beq = [];
lb = -pi * ones(K,1); ub = pi * ones(K,1);

% Estimate for each shifted break
[B_nG_1_minus2, B_nG_2_minus2, theta_hat_1_main_minus2, theta_hat_2_main_minus2] = ...
    estimate_one(Uhat_1_minus2, Uhat_2_minus2, SIGMA_1_minus2, SIGMA_2_minus2, v, theta0, K, A, b, Aeq, beq, lb, ub, nod);

[B_nG_1_minus1, B_nG_2_minus1, theta_hat_1_main_minus1, theta_hat_2_main_minus1] = ...
    estimate_one(Uhat_1_minus1, Uhat_2_minus1, SIGMA_1_minus1, SIGMA_2_minus1, v, theta0, K, A, b, Aeq, beq, lb, ub, nod);

[B_nG_1_plus1, B_nG_2_plus1, theta_hat_1_main_plus1, theta_hat_2_main_plus1] = ...
    estimate_one(Uhat_1_plus1, Uhat_2_plus1, SIGMA_1_plus1,  SIGMA_2_plus1, v, theta0, K, A, b, Aeq, beq, lb, ub, nod);

[B_nG_1_plus2, B_nG_2_plus2, theta_hat_1_main_plus2, theta_hat_2_main_plus2] = ...
    estimate_one(Uhat_1_plus2, Uhat_2_plus2, SIGMA_1_plus2,  SIGMA_2_plus2, v, theta0, K, A, b, Aeq, beq, lb, ub, nod);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Helper function to estimate B and theta for one pair of Uhat %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [B_1, B_2, theta_main_1, theta_main_2] = estimate_one(U1, U2, SIGMA_1, SIGMA_2, v, theta0, K, A, b, Aeq, beq, lb, ub, nod)

% Optimization options
options = optimoptions('fmincon', ...
    'Algorithm', 'interior-point', ...   
    'Display', 'off', ...
    'FiniteDifferenceType', 'forward', ...
    'StepTolerance', 1e-10, ...
    'OptimalityTolerance', 1e-8, ...
    'MaxIterations', 1000, ...
    'MaxFunctionEvaluations', 1e5);

u_star_1 = chol(SIGMA_1, 'lower') \ U1;
u_star_2 = chol(SIGMA_2, 'lower') \ U2;

theta_hat_1 = fmincon(@(theta) -loglik_t_3x3(u_star_1, v, theta), ...
    theta0, A, b, Aeq, beq, lb, ub, [], options);
theta_hat_2 = fmincon(@(theta) -loglik_t_3x3(u_star_2, v, theta), ...
    theta0, A, b, Aeq, beq, lb, ub, [], options);

B_1 = chol(SIGMA_1, 'lower') * Qdim3_prime_loglik(theta_hat_1)';
B_2 = chol(SIGMA_2, 'lower') * Qdim3_prime_loglik(theta_hat_2)';

B_1=chop(B_1,nod);
B_2=chop(B_2,nod);

[~, ~, Q_hat_1, ~] = rqdecomposition(K, B_1);
[~, ~, Q_hat_2, ~] = rqdecomposition(K, B_2);

theta_main_1 = thetas_from_Q_3x3(Q_hat_1);
theta_main_2 = thetas_from_Q_3x3(Q_hat_2);
end