function [Uhat_1_minus2, Uhat_2_minus2, ...
          Uhat_1_minus1, Uhat_2_minus1, ...
          Uhat_1_plus1,  Uhat_2_plus1,  ...
          Uhat_1_plus2,  Uhat_2_plus2,  ...
          SIGMA_1_minus2, SIGMA_2_minus2, ...
          SIGMA_1_minus1, SIGMA_2_minus1, ...
          SIGMA_1_plus1,  SIGMA_2_plus1,  ...
          SIGMA_1_plus2,  SIGMA_2_plus2] = VAR_residuals_for_tables_1_and_2_robustness(data, break_index, p)

%   break_index  : row index of main break date (e.g. 213)

% Initialize outputs
Uhat_1_minus2 = []; Uhat_2_minus2 = [];
Uhat_1_minus1 = []; Uhat_2_minus1 = [];
Uhat_1_plus1  = []; Uhat_2_plus1  = [];
Uhat_1_plus2  = []; Uhat_2_plus2  = [];

SIGMA_1_minus2 = []; SIGMA_2_minus2 = [];
SIGMA_1_minus1 = []; SIGMA_2_minus1 = [];
SIGMA_1_plus1  = []; SIGMA_2_plus1  = [];
SIGMA_1_plus2  = []; SIGMA_2_plus2  = [];

% Define shifts and corresponding output variables
shifts = [-2, -1, 1, 2];

for i = 1:length(shifts)
    shift = shifts(i);
    split_idx = break_index + shift;
    
    % Split data
    y_1 = data(1:split_idx - 1, :);
    y_2 = data(split_idx:end, :);

    % Estimate VARs and extract residuals and covariance matrices
    [~, SIG_1, U1, ~, ~] = olsvarc(y_1, p);
    [~, SIG_2, U2, ~, ~] = olsvarc(y_2, p);
    
    % Keep first 3 residual series
    U1 = U1(1:3,:);
    U2 = U2(1:3,:);

    % Assign to correct output variable
    switch shift
        case -2
            Uhat_1_minus2 = U1;  Uhat_2_minus2 = U2;
            SIGMA_1_minus2 = SIG_1(1:3,1:3); SIGMA_2_minus2 = SIG_2(1:3,1:3);
        case -1
            Uhat_1_minus1 = U1;  Uhat_2_minus1 = U2;
            SIGMA_1_minus1 = SIG_1(1:3,1:3); SIGMA_2_minus1 = SIG_2(1:3,1:3);
        case 1
            Uhat_1_plus1 = U1;   Uhat_2_plus1  = U2;
            SIGMA_1_plus1 = SIG_1(1:3,1:3); SIGMA_2_plus1 = SIG_2(1:3,1:3);
        case 2
            Uhat_1_plus2 = U1;   Uhat_2_plus2  = U2;
            SIGMA_1_plus2 = SIG_1(1:3,1:3); SIGMA_2_plus2 = SIG_2(1:3,1:3);
    end
end

end
