load(fullfile('..', 'data', 'Data_Kilian_2009.txt'));
break_index = 213;
p = 24;

[Uhat_1_minus2, Uhat_2_minus2, ...
    Uhat_1_minus1, Uhat_2_minus1, ...
    Uhat_1_plus1,  Uhat_2_plus1,  ...
    Uhat_1_plus2,  Uhat_2_plus2,  ...
    SIGMA_1_minus2, SIGMA_2_minus2, ...
    SIGMA_1_minus1, SIGMA_2_minus1, ...
    SIGMA_1_plus1,  SIGMA_2_plus1,  ...
    SIGMA_1_plus2,  SIGMA_2_plus2] = VAR_residuals_for_tables_1_and_2_robustness(Data_Kilian_2009, break_index, p);

[B_nG_1_minus2, B_nG_2_minus2, ~, ~, ...
    B_nG_1_minus1, B_nG_2_minus1, ~, ~, ...
    B_nG_1_plus1,  B_nG_2_plus1,  ~,  ~,  ...
    B_nG_1_plus2,  B_nG_2_plus2,  ~,  ~] = ...
    Non_normal_B_for_tables_1_and_2_robustness(Uhat_1_minus2, Uhat_2_minus2, ...
    Uhat_1_minus1, Uhat_2_minus1, ...
    Uhat_1_plus1,  Uhat_2_plus1,  ...
    Uhat_1_plus2,  Uhat_2_plus2, ...
    SIGMA_1_minus2, SIGMA_2_minus2, ...
    SIGMA_1_minus1, SIGMA_2_minus1, ...
    SIGMA_1_plus1,  SIGMA_2_plus1,  ...
    SIGMA_1_plus2,  SIGMA_2_plus2, nod);


% ordedring and signs
[B_nG_1_minus2, B_nG_2_minus2, theta_hat_1_main_minus2, theta_hat_2_main_minus2, ...
    B_nG_1_minus1, B_nG_2_minus1, theta_hat_1_main_minus1, theta_hat_2_main_minus1, ...
    B_nG_1_plus1,  B_nG_2_plus1,  theta_hat_1_main_plus1,  theta_hat_2_main_plus1,  ...
    B_nG_1_plus2,  B_nG_2_plus2,  theta_hat_1_main_plus2,  theta_hat_2_main_plus2] = ...
    ColumnSigns_robustness(B_nG_1_minus2, B_nG_2_minus2, ...
    B_nG_1_minus1, B_nG_2_minus1, ...
    B_nG_1_plus1,  B_nG_2_plus1, ...
    B_nG_1_plus2,  B_nG_2_plus2);

denom_row_minus2 = [1 2 3]; 
denom_row_minus1 = [1 3 1]; 
denom_row_plus1 = [1 3 1]; 
denom_row_plus2 = [1 3 1]; 

%%%%%%%%%%%%%
% Bootstrap %
%%%%%%%%%%%%%
S = 2000;

%%%%%%%%
% (+1) %
%%%%%%%%

theta_hat_boot_1_plus1 = zeros(3, S);
theta_hat_boot_2_plus1 = zeros(3, S);
B_hat_boot_1_plus1 = zeros(3, 3, S);
B_hat_boot_2_plus1 = zeros(3, 3, S);

u1_boot = Uhat_1_plus1;
u2_boot = Uhat_2_plus1;
s = 1;
rseed = 1;

while s < S + 1
    
    % Empirically standardized reduced-form shocks
    u_star1 = chol(cov(u1_boot'), 'lower') \ u1_boot;
    u_star2 = chol(cov(u2_boot'), 'lower') \ u2_boot;

    % Initial theta values
    theta01 = theta_hat_1_main_plus1;
    theta02 = theta_hat_2_main_plus1;

    % Optimization setup
    A = []; b = [];
    Aeq = []; beq = [];
    lb = []; ub = [];

    % Estimation
    [theta_hat_1_est, fval1] = fmincon(@(theta) -loglik_t_3x3(u_star1, v, theta), theta01, A, b, Aeq, beq, lb, ub, [], options);
    [theta_hat_2_est, fval2] = fmincon(@(theta) -loglik_t_3x3(u_star2, v, theta), theta02, A, b, Aeq, beq, lb, ub, [], options);

    % Construct B matrices
    B_hat_1 = chol(cov(u1_boot'), 'lower') * Qdim3_prime_loglik(theta_hat_1_est)';
    B_hat_2 = chol(cov(u2_boot'), 'lower') * Qdim3_prime_loglik(theta_hat_2_est)';

    % Take care of permutation and sign
    B_hat_1=chop(B_hat_1,nod);
    B_hat_2=chop(B_hat_2,nod);
    B_hat_1 = ColumnSigns_via_correlation(B_hat_1, B_nG_1_plus1, K);
    B_hat_2 = ColumnSigns_via_correlation(B_hat_2, B_nG_2_plus1, K);

    B_hat_boot_1_plus1(:, :, s) = B_hat_1;
    B_hat_boot_2_plus1(:, :, s) = B_hat_2;

    % Retrieve thetas
    [~, ~, Q_hat_1, ~] = rqdecomposition(K, B_hat_1);
    [~, ~, Q_hat_2, ~] = rqdecomposition(K, B_hat_2);
    theta_hat_1_est = thetas_from_Q_3x3(Q_hat_1);
    theta_hat_2_est = thetas_from_Q_3x3(Q_hat_2);

    theta_hat_boot_1_plus1(:, s) = theta_hat_1_est;
    theta_hat_boot_2_plus1(:, s) = theta_hat_2_est;

    % Resample bootstrap data
    stream = RandStream('dsfmt19937', 'Seed', rseed);
    rseed = rseed + 1;

    u1_boot = datasample(stream, Uhat_1_plus1, size(Uhat_1_plus1, 2), 2);
    u2_boot = datasample(stream, Uhat_2_plus1, size(Uhat_2_plus1, 2), 2);
    u1_boot = u1_boot - mean(u1_boot, 2);
    u2_boot = u2_boot - mean(u2_boot, 2);

    % Sign check
    if isequal(sign(B_hat_1), sign(B_nG_1_plus1)) && isequal(sign(B_hat_2), sign(B_nG_2_plus1))
        s = s + 1;
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Test on thetas under homoskedasticity assumption (+1) %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Cov_1_plus1 = cov(transpose(theta_hat_boot_1_plus1));
Cov_2_plus1 = cov(transpose(theta_hat_boot_2_plus1));
Wald_theta_plus1 = transpose(theta_hat_1_main_plus1 - theta_hat_2_main_plus1) * inv(Cov_1_plus1 + Cov_2_plus1) * (theta_hat_1_main_plus1 - theta_hat_2_main_plus1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Test on betas under heteroskedasticity assumption  (+1) %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Column 1
[ratio_1_column_1_plus1, Cov_standard_1_column_1_plus1] = ...
    ratios_and_cov_from_boot(B_nG_1_plus1, B_hat_boot_1_plus1, 1, denom_row_plus1);
[ratio_2_column_1_plus1, Cov_standard_2_column_1_plus1] = ...
    ratios_and_cov_from_boot(B_nG_2_plus1, B_hat_boot_2_plus1, 1, denom_row_plus1);

Wald_beta_column_1_plus1 = (ratio_1_column_1_plus1 - ratio_2_column_1_plus1).' * ...
    ((Cov_standard_1_column_1_plus1 + Cov_standard_2_column_1_plus1) \ ...
     (ratio_1_column_1_plus1 - ratio_2_column_1_plus1));

% Column 2
[ratio_1_column_2_plus1, Cov_standard_1_column_2_plus1] = ...
    ratios_and_cov_from_boot(B_nG_1_plus1, B_hat_boot_1_plus1, 2, denom_row_plus1);
[ratio_2_column_2_plus1, Cov_standard_2_column_2_plus1] = ...
    ratios_and_cov_from_boot(B_nG_2_plus1, B_hat_boot_2_plus1, 2, denom_row_plus1);

Wald_beta_column_2_plus1 = (ratio_1_column_2_plus1 - ratio_2_column_2_plus1).' * ...
    ((Cov_standard_1_column_2_plus1 + Cov_standard_2_column_2_plus1) \ ...
     (ratio_1_column_2_plus1 - ratio_2_column_2_plus1));

% Column 3
[ratio_1_column_3_plus1, Cov_standard_1_column_3_plus1] = ...
    ratios_and_cov_from_boot(B_nG_1_plus1, B_hat_boot_1_plus1, 3, denom_row_plus1);
[ratio_2_column_3_plus1, Cov_standard_2_column_3_plus1] = ...
    ratios_and_cov_from_boot(B_nG_2_plus1, B_hat_boot_2_plus1, 3, denom_row_plus1);

Wald_beta_column_3_plus1 = (ratio_1_column_3_plus1 - ratio_2_column_3_plus1).' * ...
    ((Cov_standard_1_column_3_plus1 + Cov_standard_2_column_3_plus1) \ ...
     (ratio_1_column_3_plus1 - ratio_2_column_3_plus1));


%%%%%%%%
% (+2) %
%%%%%%%%

theta_hat_boot_1_plus2 = zeros(3, S);
theta_hat_boot_2_plus2 = zeros(3, S);
B_hat_boot_1_plus2 = zeros(3, 3, S);
B_hat_boot_2_plus2 = zeros(3, 3, S);

u1_boot = Uhat_1_plus2;
u2_boot = Uhat_2_plus2;
s = 1;
rseed = 1;

while s < S + 1
    
    % Empirically standardized reduced-form shocks
    u_star1 = chol(cov(u1_boot'), 'lower') \ u1_boot;
    u_star2 = chol(cov(u2_boot'), 'lower') \ u2_boot;

    % Initial theta values
    theta01 = theta_hat_1_main_plus2;
    theta02 = theta_hat_2_main_plus2;

    % Optimization setup
    A = []; b = [];
    Aeq = []; beq = [];
    lb = []; ub = [];

    % Estimation
    [theta_hat_1_est, fval1] = fmincon(@(theta) -loglik_t_3x3(u_star1, v, theta), theta01, A, b, Aeq, beq, lb, ub, [], options);
    [theta_hat_2_est, fval2] = fmincon(@(theta) -loglik_t_3x3(u_star2, v, theta), theta02, A, b, Aeq, beq, lb, ub, [], options);

    % Construct B matrices
    B_hat_1 = chol(cov(u1_boot'), 'lower') * Qdim3_prime_loglik(theta_hat_1_est)';
    B_hat_2 = chol(cov(u2_boot'), 'lower') * Qdim3_prime_loglik(theta_hat_2_est)';

    % Take care of permutation and sign
    B_hat_1=chop(B_hat_1,nod);
    B_hat_2=chop(B_hat_2,nod);

    B_hat_1 = ColumnSigns_via_correlation(B_hat_1, B_nG_1_plus2, K);
    B_hat_2 = ColumnSigns_via_correlation(B_hat_2, B_nG_2_plus2, K);

    B_hat_boot_1_plus2(:, :, s) = B_hat_1;
    B_hat_boot_2_plus2(:, :, s) = B_hat_2;

    % Retrieve thetas
    [~, ~, Q_hat_1, ~] = rqdecomposition(K, B_hat_1);
    [~, ~, Q_hat_2, ~] = rqdecomposition(K, B_hat_2);
    theta_hat_1_est = thetas_from_Q_3x3(Q_hat_1);
    theta_hat_2_est = thetas_from_Q_3x3(Q_hat_2);

    theta_hat_boot_1_plus2(:, s) = theta_hat_1_est;
    theta_hat_boot_2_plus2(:, s) = theta_hat_2_est;

    % Resample bootstrap data
    stream = RandStream('dsfmt19937', 'Seed', rseed);
    rseed = rseed + 1;

    u1_boot = datasample(stream, Uhat_1_plus2, size(Uhat_1_plus2, 2), 2);
    u2_boot = datasample(stream, Uhat_2_plus2, size(Uhat_2_plus2, 2), 2);
    u1_boot = u1_boot - mean(u1_boot, 2);
    u2_boot = u2_boot - mean(u2_boot, 2);

    % Sign check
    if isequal(sign(B_hat_1), sign(B_nG_1_plus2)) && isequal(sign(B_hat_2), sign(B_nG_2_plus2))
        s = s + 1;
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Test on thetas under homoskedasticity assumption (+2) %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Cov_1_plus2 = cov(transpose(theta_hat_boot_1_plus2));
Cov_2_plus2 = cov(transpose(theta_hat_boot_2_plus2));
Wald_theta_plus2 = transpose(theta_hat_1_main_plus2 - theta_hat_2_main_plus2) * inv(Cov_1_plus2 + Cov_2_plus2) * (theta_hat_1_main_plus2 - theta_hat_2_main_plus2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Test on betas under heteroskedasticity assumption (+2) %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Column 1
[ratio_1_column_1_plus2, Cov_standard_1_column_1_plus2] = ...
    ratios_and_cov_from_boot(B_nG_1_plus2, B_hat_boot_1_plus2, 1, denom_row_plus2);
[ratio_2_column_1_plus2, Cov_standard_2_column_1_plus2] = ...
    ratios_and_cov_from_boot(B_nG_2_plus2, B_hat_boot_2_plus2, 1, denom_row_plus2);

Wald_beta_column_1_plus2 = (ratio_1_column_1_plus2 - ratio_2_column_1_plus2).' * ...
    ((Cov_standard_1_column_1_plus2 + Cov_standard_2_column_1_plus2) \ ...
     (ratio_1_column_1_plus2 - ratio_2_column_1_plus2));

% Column 2
[ratio_1_column_2_plus2, Cov_standard_1_column_2_plus2] = ...
    ratios_and_cov_from_boot(B_nG_1_plus2, B_hat_boot_1_plus2, 2, denom_row_plus2);
[ratio_2_column_2_plus2, Cov_standard_2_column_2_plus2] = ...
    ratios_and_cov_from_boot(B_nG_2_plus2, B_hat_boot_2_plus2, 2, denom_row_plus2);

Wald_beta_column_2_plus2 = (ratio_1_column_2_plus2 - ratio_2_column_2_plus2).' * ...
    ((Cov_standard_1_column_2_plus2 + Cov_standard_2_column_2_plus2) \ ...
     (ratio_1_column_2_plus2 - ratio_2_column_2_plus2));

% Column 3
[ratio_1_column_3_plus2, Cov_standard_1_column_3_plus2] = ...
    ratios_and_cov_from_boot(B_nG_1_plus2, B_hat_boot_1_plus2, 3, denom_row_plus2);
[ratio_2_column_3_plus2, Cov_standard_2_column_3_plus2] = ...
    ratios_and_cov_from_boot(B_nG_2_plus2, B_hat_boot_2_plus2, 3, denom_row_plus2);

Wald_beta_column_3_plus2 = (ratio_1_column_3_plus2 - ratio_2_column_3_plus2).' * ...
    ((Cov_standard_1_column_3_plus2 + Cov_standard_2_column_3_plus2) \ ...
     (ratio_1_column_3_plus2 - ratio_2_column_3_plus2));


%%%%%%%%
% (-1) %
%%%%%%%%

theta_hat_boot_1_minus1 = zeros(3, S);
theta_hat_boot_2_minus1 = zeros(3, S);
B_hat_boot_1_minus1 = zeros(3, 3, S);
B_hat_boot_2_minus1 = zeros(3, 3, S);

u1_boot = Uhat_1_minus1;
u2_boot = Uhat_2_minus1;
s = 1;
rseed = 1;

while s < S + 1
    
    % Empirically standardized reduced-form shocks
    u_star1 = chol(cov(u1_boot'), 'lower') \ u1_boot;
    u_star2 = chol(cov(u2_boot'), 'lower') \ u2_boot;

    % Initial theta values
    theta01 = theta_hat_1_main_minus1;
    theta02 = theta_hat_2_main_minus1;

    % Optimization setup
    A = []; b = [];
    Aeq = []; beq = [];
    lb = []; ub = [];

    % Estimation
    [theta_hat_1_est, fval1] = fmincon(@(theta) -loglik_t_3x3(u_star1, v, theta), theta01, A, b, Aeq, beq, lb, ub, [], options);
    [theta_hat_2_est, fval2] = fmincon(@(theta) -loglik_t_3x3(u_star2, v, theta), theta02, A, b, Aeq, beq, lb, ub, [], options);

    % Construct B matrices
    B_hat_1 = chol(cov(u1_boot'), 'lower') * Qdim3_prime_loglik(theta_hat_1_est)';
    B_hat_2 = chol(cov(u2_boot'), 'lower') * Qdim3_prime_loglik(theta_hat_2_est)';

    % Take care of permutation and sign
    B_hat_1=chop(B_hat_1,nod);
    B_hat_2=chop(B_hat_2,nod);

    B_hat_1 = ColumnSigns_via_correlation(B_hat_1, B_nG_1_minus1, K);
    B_hat_2 = ColumnSigns_via_correlation(B_hat_2, B_nG_2_minus1, K);

    B_hat_boot_1_minus1(:, :, s) = B_hat_1;
    B_hat_boot_2_minus1(:, :, s) = B_hat_2;

    % Retrieve thetas
    [~, ~, Q_hat_1, ~] = rqdecomposition(K, B_hat_1);
    [~, ~, Q_hat_2, ~] = rqdecomposition(K, B_hat_2);
    theta_hat_1_est = thetas_from_Q_3x3(Q_hat_1);
    theta_hat_2_est = thetas_from_Q_3x3(Q_hat_2);

    theta_hat_boot_1_minus1(:, s) = theta_hat_1_est;
    theta_hat_boot_2_minus1(:, s) = theta_hat_2_est;

    % Resample bootstrap data
    stream = RandStream('dsfmt19937', 'Seed', rseed);
    rseed = rseed + 1;

    u1_boot = datasample(stream, Uhat_1_minus1, size(Uhat_1_minus1, 2), 2);
    u2_boot = datasample(stream, Uhat_2_minus1, size(Uhat_2_minus1, 2), 2);
    u1_boot = u1_boot - mean(u1_boot, 2);
    u2_boot = u2_boot - mean(u2_boot, 2);

    % Sign check
    if isequal(sign(B_hat_1), sign(B_nG_1_minus1)) && isequal(sign(B_hat_2), sign(B_nG_2_minus1))
        s = s + 1;
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Test on thetas under homoskedasticity assumption (-1) %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Cov_1_minus1 = cov(transpose(theta_hat_boot_1_minus1));
Cov_2_minus1 = cov(transpose(theta_hat_boot_2_minus1));
Wald_theta_minus1 = transpose(theta_hat_1_main_minus1 - theta_hat_2_main_minus1) * inv(Cov_1_minus1 + Cov_2_minus1) * (theta_hat_1_main_minus1 - theta_hat_2_main_minus1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Test on betas under heteroskedasticity assumption (-1) %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Column 1
[ratio_1_column_1_minus1, Cov_standard_1_column_1_minus1] = ...
    ratios_and_cov_from_boot(B_nG_1_minus1, B_hat_boot_1_minus1, 1, denom_row_minus1);
[ratio_2_column_1_minus1, Cov_standard_2_column_1_minus1] = ...
    ratios_and_cov_from_boot(B_nG_2_minus1, B_hat_boot_2_minus1, 1, denom_row_minus1);

Wald_beta_column_1_minus1 = (ratio_1_column_1_minus1 - ratio_2_column_1_minus1).' * ...
    ((Cov_standard_1_column_1_minus1 + Cov_standard_2_column_1_minus1) \ ...
     (ratio_1_column_1_minus1 - ratio_2_column_1_minus1));

% Column 2
[ratio_1_column_2_minus1, Cov_standard_1_column_2_minus1] = ...
    ratios_and_cov_from_boot(B_nG_1_minus1, B_hat_boot_1_minus1, 2, denom_row_minus1);
[ratio_2_column_2_minus1, Cov_standard_2_column_2_minus1] = ...
    ratios_and_cov_from_boot(B_nG_2_minus1, B_hat_boot_2_minus1, 2, denom_row_minus1);

Wald_beta_column_2_minus1 = (ratio_1_column_2_minus1 - ratio_2_column_2_minus1).' * ...
    ((Cov_standard_1_column_2_minus1 + Cov_standard_2_column_2_minus1) \ ...
     (ratio_1_column_2_minus1 - ratio_2_column_2_minus1));

% Column 3
[ratio_1_column_3_minus1, Cov_standard_1_column_3_minus1] = ...
    ratios_and_cov_from_boot(B_nG_1_minus1, B_hat_boot_1_minus1, 3, denom_row_minus1);
[ratio_2_column_3_minus1, Cov_standard_2_column_3_minus1] = ...
    ratios_and_cov_from_boot(B_nG_2_minus1, B_hat_boot_2_minus1, 3, denom_row_minus1);

Wald_beta_column_3_minus1 = (ratio_1_column_3_minus1 - ratio_2_column_3_minus1).' * ...
    ((Cov_standard_1_column_3_minus1 + Cov_standard_2_column_3_minus1) \ ...
     (ratio_1_column_3_minus1 - ratio_2_column_3_minus1));

%%%%%%%%
% (-2) %
%%%%%%%%

theta_hat_boot_1_minus2 = zeros(3, S);
theta_hat_boot_2_minus2 = zeros(3, S);
B_hat_boot_1_minus2 = zeros(3, 3, S);
B_hat_boot_2_minus2 = zeros(3, 3, S);

u1_boot = Uhat_1_minus2;
u2_boot = Uhat_2_minus2;
s = 1;
rseed = 1;

while s < S + 1
    
    % Empirically standardized reduced-form shocks
    u_star1 = chol(cov(u1_boot'), 'lower') \ u1_boot;
    u_star2 = chol(cov(u2_boot'), 'lower') \ u2_boot;

    % Initial theta values
    theta01 = theta_hat_1_main_minus2;
    theta02 = theta_hat_2_main_minus2;

    % Optimization setup
    A = []; b = [];
    Aeq = []; beq = [];
    lb = []; ub = [];

    % Estimation
    [theta_hat_1_est, fval1] = fmincon(@(theta) -loglik_t_3x3(u_star1, v, theta), theta01, A, b, Aeq, beq, lb, ub, [], options);
    [theta_hat_2_est, fval2] = fmincon(@(theta) -loglik_t_3x3(u_star2, v, theta), theta02, A, b, Aeq, beq, lb, ub, [], options);

    % Construct B matrices
    B_hat_1 = chol(cov(u1_boot'), 'lower') * Qdim3_prime_loglik(theta_hat_1_est)';
    B_hat_2 = chol(cov(u2_boot'), 'lower') * Qdim3_prime_loglik(theta_hat_2_est)';

    % Take care of permutation and sign
    B_hat_1=chop(B_hat_1,nod);
    B_hat_2=chop(B_hat_2,nod);

    B_hat_1 = ColumnSigns_via_correlation(B_hat_1, B_nG_1_minus2, K);
    B_hat_2 = ColumnSigns_via_correlation(B_hat_2, B_nG_2_minus2, K);

    B_hat_boot_1_minus2(:, :, s) = B_hat_1;
    B_hat_boot_2_minus2(:, :, s) = B_hat_2;

    % Retrieve thetas
    [~, ~, Q_hat_1, ~] = rqdecomposition(K, B_hat_1);
    [~, ~, Q_hat_2, ~] = rqdecomposition(K, B_hat_2);
    theta_hat_1_est = thetas_from_Q_3x3(Q_hat_1);
    theta_hat_2_est = thetas_from_Q_3x3(Q_hat_2);

    theta_hat_boot_1_minus2(:, s) = theta_hat_1_est;
    theta_hat_boot_2_minus2(:, s) = theta_hat_2_est;

    % Resample bootstrap data
    stream = RandStream('dsfmt19937', 'Seed', rseed);
    rseed = rseed + 1;

    u1_boot = datasample(stream, Uhat_1_minus2, size(Uhat_1_minus2, 2), 2);
    u2_boot = datasample(stream, Uhat_2_minus2, size(Uhat_2_minus2, 2), 2);
    u1_boot = u1_boot - mean(u1_boot, 2);
    u2_boot = u2_boot - mean(u2_boot, 2);

    % Sign check
    if isequal(sign(B_hat_1), sign(B_nG_1_minus2)) && isequal(sign(B_hat_2), sign(B_nG_2_minus2))
        s = s + 1;
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Test on thetas under homoskedasticity assumption (-2) %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Cov_1_minus2 = cov(transpose(theta_hat_boot_1_minus2));
Cov_2_minus2 = cov(transpose(theta_hat_boot_2_minus2));
Wald_theta_minus2 = transpose(theta_hat_1_main_minus2 - theta_hat_2_main_minus2) * inv(Cov_1_minus2 + Cov_2_minus2) * (theta_hat_1_main_minus2 - theta_hat_2_main_minus2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Test on betas under heteroskedasticity assumption (-2) %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Column 1
[ratio_1_column_1_minus2, Cov_standard_1_column_1_minus2] = ...
    ratios_and_cov_from_boot(B_nG_1_minus2, B_hat_boot_1_minus2, 1, denom_row_minus2);
[ratio_2_column_1_minus2, Cov_standard_2_column_1_minus2] = ...
    ratios_and_cov_from_boot(B_nG_2_minus2, B_hat_boot_2_minus2, 1, denom_row_minus2);

Wald_beta_column_1_minus2 = (ratio_1_column_1_minus2 - ratio_2_column_1_minus2).' * ...
    ((Cov_standard_1_column_1_minus2 + Cov_standard_2_column_1_minus2) \ ...
     (ratio_1_column_1_minus2 - ratio_2_column_1_minus2));

% Column 2
[ratio_1_column_2_minus2, Cov_standard_1_column_2_minus2] = ...
    ratios_and_cov_from_boot(B_nG_1_minus2, B_hat_boot_1_minus2, 2, denom_row_minus2);
[ratio_2_column_2_minus2, Cov_standard_2_column_2_minus2] = ...
    ratios_and_cov_from_boot(B_nG_2_minus2, B_hat_boot_2_minus2, 2, denom_row_minus2);

Wald_beta_column_2_minus2 = (ratio_1_column_2_minus2 - ratio_2_column_2_minus2).' * ...
    ((Cov_standard_1_column_2_minus2 + Cov_standard_2_column_2_minus2) \ ...
     (ratio_1_column_2_minus2 - ratio_2_column_2_minus2));

% Column 3
[ratio_1_column_3_minus2, Cov_standard_1_column_3_minus2] = ...
    ratios_and_cov_from_boot(B_nG_1_minus2, B_hat_boot_1_minus2, 3, denom_row_minus2);
[ratio_2_column_3_minus2, Cov_standard_2_column_3_minus2] = ...
    ratios_and_cov_from_boot(B_nG_2_minus2, B_hat_boot_2_minus2, 3, denom_row_minus2);

Wald_beta_column_3_minus2 = (ratio_1_column_3_minus2 - ratio_2_column_3_minus2).' * ...
    ((Cov_standard_1_column_3_minus2 + Cov_standard_2_column_3_minus2) \ ...
     (ratio_1_column_3_minus2 - ratio_2_column_3_minus2));

%%%%%%%%%%%%%%%%%%
% Output Results %
%%%%%%%%%%%%%%%%%%
fprintf('\n===================================================\n');
fprintf('Table 1: Wald Tests on Thetas (Homoskedasticity)\n');
fprintf('===================================================\n');
fprintf('%-12s %-12s %-12s\n','Change in','Wald Stat.','p-value');
fprintf('---------------------------------------------------\n');
cp = {'1990M7','1990M8','1990M9','1990M10','1990M11'};
wald = [Wald_theta_minus2; Wald_theta_minus1; Wald_theta; Wald_theta_plus1; Wald_theta_plus2];
pval = 1 - chi2cdf(wald,3);
for i = 1:length(cp)
    fprintf('%-12s %-12.3f %-12.3f\n',cp{i},wald(i),pval(i));
end
fprintf('===================================================\n\n');

fprintf('\n=====================================================================================\n');
fprintf('Table 2: Wald Tests on Betas (Heteroskedasticity)\n');
fprintf('=====================================================================================\n');
fprintf('%-12s %-24s %-24s %-24s\n', ...
    ' ', 'oil supply', 'aggregate demand', 'oil-specific demand');
fprintf('%-12s %-12s %-12s %-12s %-12s %-12s %-12s\n', ...
    'Change in','Wald Stat.','p-value',...
    'Wald Stat.','p-value','Wald Stat.','p-value');
fprintf('-------------------------------------------------------------------------------------\n');
wald_c1 = [Wald_beta_column_1_minus2; Wald_beta_column_1_minus1; Wald_beta_column_1; Wald_beta_column_1_plus1; Wald_beta_column_1_plus2];
wald_c2 = [Wald_beta_column_2_minus2; Wald_beta_column_2_minus1; Wald_beta_column_2; Wald_beta_column_2_plus1; Wald_beta_column_2_plus2];
wald_c3 = [Wald_beta_column_3_minus2; Wald_beta_column_3_minus1; Wald_beta_column_3; Wald_beta_column_3_plus1; Wald_beta_column_3_plus2];

p1 = 1 - chi2cdf(wald_c1,2);
p2 = 1 - chi2cdf(wald_c2,2);
p3 = 1 - chi2cdf(wald_c3,2);

for i = 1:length(cp)
    fprintf('%-12s %-12.3f %-12.3f %-12.3f %-12.3f %-12.3f %-12.3f\n', ...
        cp{i}, wald_c1(i), p1(i), wald_c2(i), p2(i), wald_c3(i), p3(i));
end
fprintf('=====================================================================================\n\n');
