%-------------------------------------------------------------
% Figure 1: Reduced-form residuals of the VAR(24) model
%-------------------------------------------------------------

% - Uhat: 3×(T - p) matrix of residuals from VAR
% - time: T×1 vector with full-sample decimal dates
% - p: number of lags used in VAR

time_trunc = time(p+1:end);  % Align time vector with Uhat

% Define ticks and labels: every year, but only label even years
years = floor(min(time_trunc)) : 1 : ceil(max(time_trunc));
tick_labels = arrayfun(@num2str, years, 'UniformOutput', false);
for i = 1:length(tick_labels)
    if mod(years(i), 2) ~= 0
        tick_labels{i} = '';  % blank odd years
    end
end

figure('Position', [100, 100, 700, 600]);

titles = { ...
    'Percentage Change in Crude Oil Production: Residuals', ...
    'Index of Real Economic Activity: Residuals', ...
    'Real Price of Oil: Residuals'};

for i = 1:3
    subplot(3,1,i);
    plot(time_trunc, Uhat(i,:), 'k', 'LineWidth', 1); hold on;
    yline(0, 'k-');  
    xlim([min(years), max(years)]);
    xticks(years);
    xticklabels(tick_labels);
    set(gca, 'FontSize', 8);              
    set(gca, 'XTickLabelRotation', 0); 

    if i == 1
        ylim([-80, 80]);
        yticks([-80, -40, 0, 40, 80]);
    end

    title(titles{i}, 'FontWeight', 'normal');
end

% Save figure
print('-dpng', '-r300', fullfile('..', 'output', 'Figure1_VAR_Residuals'));
