%-------------------------------------------------------------
% Replicate Cholesky IRFs from Kilian (2009)
%-------------------------------------------------------------
[IRF_Chol_1] = irfvar(A_1, SIGMA_1, p, h);
IRF_Chol_1(1,:) = cumsum(IRF_Chol_1(1,:));
IRF_Chol_1(4,:) = cumsum(IRF_Chol_1(4,:));
IRF_Chol_1(7,:) = cumsum(IRF_Chol_1(7,:));
IRF_Chol_1(1:3,:) = -IRF_Chol_1(1:3,:);

[IRF_Chol_2] = irfvar(A_2, SIGMA_2, p, h);
IRF_Chol_2(1,:) = cumsum(IRF_Chol_2(1,:));
IRF_Chol_2(4,:) = cumsum(IRF_Chol_2(4,:));
IRF_Chol_2(7,:) = cumsum(IRF_Chol_2(7,:));
IRF_Chol_2(1:3,:) = -IRF_Chol_2(1:3,:);

%-------------------------------------------------------------
% IRFs from the non-Gaussian SVAR
%-------------------------------------------------------------
[IRF_1, CI1LO_1, CI2LO_1, CI1UP_1, CI2UP_1] = ...
    irfvar_nonGaussian_with_bands(Uhat_1, y_1, B_nG_1, A_1, V_1, p, h, K, options);

[IRF_2, CI1LO_2, CI2LO_2, CI1UP_2, CI2UP_2] = ...
    irfvar_nonGaussian_with_bands(Uhat_2, y_2, B_nG_2, A_2, V_2, p, h, K, options);

%-------------------------------------------------------------
% Plot: 3x3 Subplots of Impulse Response Functions
%-------------------------------------------------------------
light_red   = [1.0000 0.4118 0.1608];
darker_blue = [0.1 0.4 0.8];

T_irf_show = 16;
n_subplots = 9;

titles = {
    'Oil supply shock', 'Aggregate demand shock', 'Oil-specific demand shock', ...
    'Oil supply shock', 'Aggregate demand shock', 'Oil-specific demand shock', ...
    'Oil supply shock', 'Aggregate demand shock', 'Oil-specific demand shock'
};

ylabels = {
    'Oil production', 'Oil production', 'Oil production', ...
    'Real activity',  'Real activity',  'Real activity', ...
    'Real price of oil', 'Real price of oil', 'Real price of oil'
};

figure('Position', [100, 100, 800, 1600], 'Color', [1 1 1]);
set(gcf, 'PaperPositionMode', 'auto');
set(gcf, 'PaperOrientation', 'portrait');

alli = [1, 4, 7, 2, 5, 8, 3, 6, 9];
for j = 1:n_subplots
    subplot(3, 3, j);
    i = alli(j);
    hold on;

    % Confidence interval and IRF: Sample 1
    fill([0:T_irf_show-1, fliplr(0:T_irf_show-1)], ...
         [CI1UP_1(i,:), fliplr(CI1LO_1(i,:))], ...
         darker_blue, 'EdgeColor', 'none', 'FaceAlpha', 0.3);
    plot(0:T_irf_show-1, IRF_1(i,:), '-b', 'LineWidth', 2);

    % Confidence interval and IRF: Sample 2
    fill([0:T_irf_show-1, fliplr(0:T_irf_show-1)], ...
         [CI1UP_2(i,:), fliplr(CI1LO_2(i,:))], ...
         light_red, 'EdgeColor', 'none', 'FaceAlpha', 0.3);
    plot(0:T_irf_show-1, IRF_2(i,:), '-r', 'LineWidth', 2);

    % Zero line
    plot([0, T_irf_show-1], [0, 0], '--k', 'LineWidth', 1);

    % Cholesky IRFs
    plot(0:T_irf_show-1, IRF_Chol_1(i,:), '--b', 'LineWidth', 2);
    plot(0:T_irf_show-1, IRF_Chol_2(i,:), '--r', 'LineWidth', 2);

    % Labels
    title(titles{j}, 'Interpreter', 'latex');
    ylabel(ylabels{j}, 'Interpreter', 'latex');
    xlabel('Months', 'Interpreter', 'latex');

    xlim([0, T_irf_show-1]);
    ylim auto;
    grid on;
    box off;

    ax = gca;
    ax.LineWidth = 1;
end

% Export as PDF
print('-dpdf', '-r300', fullfile('..', 'output', 'IRF_Figure.pdf'));


