%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Estimate reduced-form VAR and Cholesky SVAR (Kilian 2009) %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% load the data from Kilian (2009)
% and estimate the VAR by OLS over the full sample

global h t p 

% The monthly data range from 1973.2 to 2007.12. 
% The file Data_Kilian_2009.txt has 3 columns with time series:
% 1: Growth rate of world oil production 
% 2: Global real activity index
% 3: Real price of oil 

load(fullfile('..', 'data', 'Data_Kilian_2009.txt'));
y=Data_Kilian_2009;
[t,K]=size(y); % full sample

time=(1973+2/12:1/12:2007+12/12)';  % full sample

h=15;                               % Impulse response horizon
p=24;                               % VAR lag order
[A,SIGMA,Uhat,V,X]=olsvarc(y,p);	% Estimate reduced-form VAR with intercept by OLS	
SIGMA=SIGMA(1:K,1:K);               % Get SIGMA

% get residuals
Uhat=Uhat(1:3,:);

% compute structural B-Matrix through Cholesky decomposition
B_Chol=chol(SIGMA)'*diag([-1 1 1]); %full sample

% Output: B_Chol contains structural impact matrix
disp('Recursive B-Matrix (Cholesky, full sample):');
fprintf('%10.2f %10.2f %10.2f\n', B_Chol.');
