%-------------------------------------------------------------
% Estimate Cholesky-identified B-matrices for two subsamples
%-------------------------------------------------------------

% Load data
load(fullfile('..', 'data', 'Data_Kilian_2009.txt'));

% Split data into two subsamples
y_1 = Data_Kilian_2009(1:212, :);     % 1973M2 – 1990M9
y_2 = Data_Kilian_2009(213:end, :);   % 1990M10 – 2007M12
[t_1, K] = size(y_1);
[t_2, ~] = size(y_2);                

% Time vectors (decimal format)
time_1 = (1973 + 2/12 : 1/12 : 1990 + 9/12)';     % Subsample 1
time_2 = (1990 + 10/12 : 1/12 : 2007 + 12/12)';   % Subsample 2

% Model settings
h = 15;   % Impulse response horizon
p = 24;   % Number of lags in VAR

% Estimate reduced-form VARs with intercepts
[A_1, SIGMA_1, Uhat_1, V_1, X_1] = olsvarc(y_1, p);
[A_2, SIGMA_2, Uhat_2, V_2, X_2] = olsvarc(y_2, p);

% Keep only relevant part of SIGMA
SIGMA_1 = SIGMA_1(1:K, 1:K);
SIGMA_2 = SIGMA_2(1:K, 1:K);

% Cholesky identification
B_Chol_1 = chol(SIGMA_1)' * diag([-1, 1, 1]);
B_Chol_2 = chol(SIGMA_2)' * diag([-1, 1, 1]);

% get residuals
Uhat_1=Uhat_1(1:3,:);
Uhat_2=Uhat_2(1:3,:);

% Output results
disp('-------------------------------------------------------------');
disp('Recursive B-Matrix (Cholesky) — First Subsample (1973M2–1990M9):');
fprintf('%10.2f %10.2f %10.2f\n', B_Chol_1.');
disp('-------------------------------------------------------------');
disp('Recursive B-Matrix (Cholesky) — Second Subsample (1990M10–2007M12):');
fprintf('%10.2f %10.2f %10.2f\n', B_Chol_2.');
disp('-------------------------------------------------------------');

