function [IRF, CI1LO, CI2LO, CI1UP, CI2UP]=...
    irfvar_nonGaussian_with_bands(Uhat, y,B_true,A,V,p,h,K, options)

% VAR Impulse response analysis point estimate
[IRF]=irfvar_nonGaussian(A,B_true,p,h);
IRF(1,:)=cumsum(IRF(1,:));
IRF(4,:)=cumsum(IRF(4,:));
IRF(7,:)=cumsum(IRF(7,:));

% VAR bootstrap
randn('seed',1234);
nrep=2000;
IRFmat=zeros(nrep,(K^2)*(h+1));

[t,K]=size(y);
y=y';
Y=y(:,p:t);
for i=1:p-1
    Y=[Y; y(:,p-i:t-i)];
end

Ur=zeros(K*p,t-p);
Yr=zeros(K*p,t-p+1);
U=Uhat;
for r=1:nrep
    %r
    pos=fix(rand(1,1)*(t-p+1))+1;
    Yr(:,1)=Y(:,pos);

    % Recursive design WB
    eta=randn(1,size(Uhat,2));  eta=[eta; eta; eta];
    Ur(1:K,2:t-p+1)=U(1:K,:).*eta;

    for i=2:t-p+1
        Yr(:,i)= V + A*Yr(:,i-1)+Ur(:,i);
    end

    yr=[Yr(1:K,:)];
    for i=2:p
        yr=[Yr((i-1)*K+1:i*K,1) yr];
    end
    yr=yr';

    [Ar,SIGMAr, Uhat]=olsvarc(yr,p);
    Uhat=Uhat(1:K,:);
    SIGMAr=SIGMAr(1:K,1:K);

    %%%estimation%%%
    K=3; % 3 variables
    %assumption on distribution%
    v=5; % assume t dist with v degrees of freedom
    u_star=chol(SIGMAr,'lower')\Uhat; %empirically stardardized reduced form shocks
    %minimize negative log likelihood for K=3
    theta0=[-0.25*pi, 0.25*pi, 0.4*pi]'; %initial theta values
    Aieq = []; %linear inequality constraints
    b = [];
    Aeq = []; %linear equality constraints
    beq = [];
    lb = []; %lower bounds for nonlinear constraint of theta
    ub = []; %upper bounds for nonlinear constraint of theta
    theta_hat=fmincon(@(theta) -loglik_t_3x3(u_star, v, theta), theta0, Aieq, b, Aeq, beq, lb, ub, [], options);
    B_hat=chol(SIGMAr,'lower')*Qdim3_prime_loglik(theta_hat)';
    %taking care of permutation and sign "according" to point estimate of B
    B_hat=ColumnSigns_via_correlation(B_hat,B_true,K);
    % Compute IRFs
    IRFr=irfvar_nonGaussian(Ar,B_hat,p,h);
    IRFr(1,:)=cumsum(IRFr(1,:));
    IRFr(4,:)=cumsum(IRFr(4,:));
    IRFr(7,:)=cumsum(IRFr(7,:));
    IRFmat(r,:)=vec(IRFr)';
end
IRFrstd=reshape((std(IRFmat)'),K^2,h+1);
CI1LO=IRF-1*IRFrstd; CI1UP=IRF+1*IRFrstd;
CI2LO=IRF-2*IRFrstd; CI2UP=IRF+2*IRFrstd;

IRF_1=IRF;
CI1LO_1=CI1LO;
CI2LO_1=CI2LO;
CI1UP_1=CI1UP;
CI2UP_1=CI2UP;

end