function [JB, pval, S, K] = multivariate_jarque_bera(X)
    [n, k] = size(X);
    X = (X - mean(X)) ./ std(X);  % standardize
    S = skewness(X);              % 1 x k
    K = kurtosis(X);              % 1 x k

    % Compute test statistic
    JB_skew = n / 6 * sum(S.^2);
    JB_kurt = n / 24 * sum((K - 3).^2);
    JB = JB_skew + JB_kurt;
    
    % Degrees of freedom = 2k
    pval = 1 - chi2cdf(JB, 2 * k);
end
