%%% Testing for Non-Normality and Independence %%%

%-------------------------------------------------------------
% Multivariate Jarque-Bera Test on Reduced-Form Residuals
%-------------------------------------------------------------
[JB, pval, S, K] = multivariate_jarque_bera(Uhat_1');
fprintf('\nJB test (reduced form, subsample 1): JB = %.4f, p = %.4f\n', JB, pval);

[JB, pval, S, K] = multivariate_jarque_bera(Uhat_2');
fprintf('JB test (reduced form, subsample 2): JB = %.4f, p = %.4f\n', JB, pval);

%-------------------------------------------------------------
% Structural Shocks: w = B⁻¹ * Uhat
%-------------------------------------------------------------
w_1 = B_nG_1 \ Uhat_1;
w_2 = B_nG_2 \ Uhat_2;

%-------------------------------------------------------------
% Multivariate Jarque-Bera Test on Structural Residuals
%-------------------------------------------------------------
[JB, pval, S, K] = multivariate_jarque_bera(w_1');
fprintf('\nJB test (structural form, subsample 1): JB = %.4f, p = %.4f\n', JB, pval);

[JB, pval, S, K] = multivariate_jarque_bera(w_2');
fprintf('JB test (structural form, subsample 2): JB = %.4f, p = %.4f\n', JB, pval);

%-------------------------------------------------------------
% Bakirov et al. (2006) test for independence
%-------------------------------------------------------------
fprintf('\nBakirov et al. (2006) test for independence (distance covariance with permutation p-values):\n');

B = 500;  % number of permutations
rng('default'); 
rng(123);

% Subsample 1 (w_1)
fprintf('Subsample 1 (w_1):\n');
for i = 1:2
    for j = i+1:3
        x = w_1(i,:)';
        y = w_1(j,:)';
        [Vxy, pval] = distance_covariance_test(x, y, B);
        fprintf('Indep test w_1(shock %d vs. %d): V = %.4f, p = %.4f\n', i, j, Vxy, pval);
    end
end

% Subsample 2 (w_2)
fprintf('Subsample 2 (w_2):\n');
for i = 1:2
    for j = i+1:3
        x = w_2(i,:)';
        y = w_2(j,:)';
        [Vxy, pval] = distance_covariance_test(x, y, B);
        fprintf('Indep test w_2(shock %d vs. %d): V = %.4f, p = %.4f\n', i, j, Vxy, pval);
    end
end


