function [ratio_main, Cov_ratio] = ratios_and_cov_from_boot(B_main, B_boot, col, denom_row)
% B_main : 3x3 point estimate for a specific subsample
% B_boot : 3x3xS estimates during bootstrap
% col    : which column
% denom_row : 1x3 vector specifying denominator row for each column

    d = denom_row(col);           % denominator row for this column
    rows = setdiff(1:3, d);       % the two numerator rows

    % main ratios
    ratio_main = [ B_main(rows(1),col)/B_main(d,col); ...
                   B_main(rows(2),col)/B_main(d,col) ];

    % bootstrap ratios
    denom = squeeze(B_boot(d,col,:)).';
    r1    = squeeze(B_boot(rows(1),col,:)).' ./ denom;
    r2    = squeeze(B_boot(rows(2),col,:)).' ./ denom;
    Rboot = [r1; r2];                                 

    % standard covariance of ratio
    Cov_ratio = cov(Rboot.', 1);
end
