%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Replication File: MAIN_simulation_Table_S4.m
% Purpose: Size & Power for homoskedastic case (K = 3)
% Author: Helmut Lütkepohl and Till Strohsal
% Date: 12.12.2025
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear; clc;

% number of decimals in B matrix to drop to improve reproducibility
nod = 2;

% Grid of sample sizes (per subsample)
T_grid = [100 200 500 1000];
nT     = numel(T_grid);

% Simulation settings
L = 1000;   % Monte Carlo replications
S = 100;    % bootstrap replications

% Result matrix
SizePowerTable = zeros(nT, 6);

for tIdx = 1:nT
    T = T_grid(tIdx);
    fprintf('\n===============================\n');
    fprintf('Running simulations for T = %d\n', T);
    fprintf('===============================\n');

    [rej_size10, rej_size5, rej_size1, ...
     rej_power10, rej_power5, rej_power1] = ...
        simulation_3x3_size_power_T_homo(T, L, S, nod);

    SizePowerTable(tIdx, :) = [rej_size10, rej_size5, rej_size1, ...
                               rej_power10, rej_power5, rej_power1];
end

%% Print table
fprintf('\n==============================================================\n');
fprintf('Table S4: Size and Power (K = 3, homoskedastic)\n');
fprintf('==============================================================\n');
fprintf('                  Size                        Power\n');
fprintf('   T       0.10   0.05   0.01          0.10   0.05   0.01\n');
fprintf('--------------------------------------------------------------\n');

for tIdx = 1:nT
    T  = T_grid(tIdx);
    sz = SizePowerTable(tIdx,1:3);
    pw = SizePowerTable(tIdx,4:6);
    fprintf('%5d     %6.3f %6.3f %6.3f        %6.3f %6.3f %6.3f\n', ...
        2*T, sz(1), sz(2), sz(3), pw(1), pw(2), pw(3));
end

fprintf('==============================================================\n\n');